//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.3

import wesual.Controls 1.0

import wesual.data.Core 1.0

Item {
    id : editor

    property Document document
    property list<TranslationProperty> properties

    width : parent ? parent.width : 100
    height : translationEditor.height//childrenRect.height
    enabled : document !== null

    onDocumentChanged : {
        if (!document)
            return;

        if (document.context !== translationEditor.context) {
            translationEditor.context = document.context;
        }
    }

    // prevent deselection of the current product on click outside of controls
    MouseArea {
        id : stealClickFromEditor
        anchors.fill : parent
        onClicked : {}
    }

    Component {
        id : editorBlock

        Item {
            width : parent ? parent.width : 100
            height : childrenRect.height

            Row {
                id : header
                spacing : 4
                height  : visible ? flag.implicitHeight + 8 : 0
                visible : languageListing.documents.length > 1
                Image {
                    id : flag
                    source : modelData.flag
                    anchors.verticalCenter : parent.verticalCenter
                }
                Label {
                    text : modelData.name
                    anchors.verticalCenter : parent.verticalCenter
                }
            }

            Column {
                readonly property string language : modelData.code

                spacing : 4
                width : parent.width
                height : childrenRect.height
                anchors.top : header.bottom

                Repeater {
                    model : editor.properties
                    delegate : editorRow
                }
            }
        }
    }

    Component {
        id : editorRow

        Item {
            property LangString translation :
                document ? document.langStrings[modelData.name] : null

            readonly property string language :
                parent ? parent.language : ""

            readonly property string text :
                (translation && translation.items[language]) ?
                    translation.items[language] : ""

            width : parent ? parent.width : 100
            height : childrenRect.height

            Label {
                id : label

                text : document ? document.propertyName(modelData.name) : ""
                anchors.left : parent.left
                anchors.top : langstring.top
                anchors.topMargin : 3
                width : parent.width / 3
            }
            LangStringEditor {
                id : langstring
                document : editor.document
                property : modelData.name
                language : parent.language
                anchors.left : label.right
                anchors.right : parent.right
                anchors.leftMargin : 4

                multiline : modelData.multiline
                wrapMode : modelData.multiline ? Text.WordWrap : Text.NoWrap
            }
        }
    }

    Column {
        id : translationEditor

        property Context context

        width : parent.width
        height : childrenRect.height

        TypeListing {
            id : languageListing

            type : "language"
            context : _we_globalContext || null
        }

        Repeater {
            model : languageListing.documents
            delegate : editorBlock
        }
    }
}
